#ifndef BMP_H
#define BMP_H

#define BMPSIGN (('M'<<8) + 'B')

#pragma pack(1)
struct BMPHeader
{
  unsigned short int sign;
  unsigned int tailleF;
  unsigned short int res1;
  unsigned short int res2;
  unsigned int offsetImage;
};

struct BMPinfo
{
  unsigned int tailleZI;
  unsigned int w;
  unsigned int h;
  unsigned short int nbPlan;
  unsigned short int bitPPixel;
  unsigned int compression;
  
  unsigned int tailleImg;
  unsigned int resH;
  unsigned int resV;
  unsigned int nbColor;
  unsigned int nbColorId;
};
#pragma pack(4)

//structure de texture charge
struct STex
{
 int w,h;//dimention de la texture
 GLubyte *ptr;//pointeur sur le tableau composante de taille w*h*x avec x=3 ou 4 suivant si on a le Alpha
};

//Charge un fichier BMP
//si colorKey=true alors la texture aurra du Alpha et on peut lui prciser
//le niveau de transparence trsp des zone qui sont visible a savoir celle qui ne sont pas de couleur (kr,kg,kb)
STex loadBMP(const char *filename,bool colorKey=false,unsigned char trsp=255,unsigned char kr=0,unsigned char kg=0,unsigned char kb=0);

//Fonction qui se charge de crer directement une texture 2D.
GLuint makeTex2D_BMP(char *filenames,bool colorKey=false,unsigned char trsp=255,unsigned char r=0,unsigned char g=0,unsigned char b=0,bool rept=true);
//void clearTex(STex st);
//lire BGR

//Fonction qui se charge de crer directement une texture 3D avec le nombre de texture et le tableau de nom des textures.
GLuint makeTex3D_BMP(int nbTex,char *filenames[]);

#endif
